---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：51-フォームレイアウト（Foundation 5）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **Foundation 5レガシー状態の記述**：公式ドキュメントの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bridge/Twig/Resources/views/Form/foundation_5_layout.html.twig`（テンプレートソースコード、346行）
- E-02: `src/Symfony/Bridge/Twig/Resources/views/Form/form_div_layout.html.twig`（親テーマソースコード、482行）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面一覧）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能マッピング）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | form_div_layout.html.twigを継承している | E-01 行1 `{% extends 'form_div_layout.html.twig' %}` | ○ |
| C-02 | form_widget_simpleでエラー時にerrorクラスを付与する | E-01 行7-8 `{% if errors\|length > 0 %}{% set attr = attr\|merge({class: ... 'error'}) %}` | ○ |
| C-03 | button_widgetでbuttonクラスを付与する | E-01 行21 `{% set attr = attr\|merge({class: ... 'button'}) %}` | ○ |
| C-04 | money_widgetでrow collapseグリッドを使用する | E-01 行26 `<div class="row collapse">` | ○ |
| C-05 | 通貨記号の位置がmoney_patternで決定される | E-01 行27-28 `{% set prepend = '{{' == money_pattern[0:2] %}{% if not prepend %}` | ○ |
| C-06 | percent_widgetでrow collapseグリッドを使用する | E-01 行45 `<div class="row collapse">` | ○ |
| C-07 | datetime_widgetでlarge-7とlarge-5カラムで配置する | E-01 行67-72 `<div class="large-7 columns">` `<div class="large-5 columns">` | ○ |
| C-08 | date_widgetでlarge-4カラムで年月日を配置する | E-01 行86-88 `<div class="large-4 columns">` | ○ |
| C-09 | choice_widget_collapsedでエラー時にerrorクラスを付与する | E-01 行146-148 | ○ |
| C-10 | multipleセレクトにdata-customforms="disabled"を付与する | E-01 行157 `multiple="multiple" data-customforms="disabled"` | ○ |
| C-11 | choice_widget_expandedでインラインリスト表示をサポートする | E-01 行180 `{% if '-inline' in label_attr.class %}` 行181 `<ul class="inline-list">` | ○ |
| C-12 | form_labelでエラー時にerrorクラスを付与する | E-01 行230-232 | ○ |
| C-13 | form_row_renderでrow/large-12 columnsでラップする | E-01 行285-286 `class="row"` `class="large-12 columns"` | ○ |
| C-14 | form_errorsで子フォームはsmall.error、ルートはalert-boxで表示する | E-01 行339-343 `{% if form is not rootform %}<small class="error">{% else %}<div data-alert class="alert-box alert">` | ○ |
| C-15 | エラーメッセージはカンマ区切りで表示される | E-01 行341 `{% if not loop.last %}, {% endif %}` | ○ |
| C-16 | 関連機能としてForm（No.34）とTwig Bridge（No.36）が主機能 | E-04 行128-129 | ○ |
| C-17 | separator_html変数による区切り線のHTML/テキスト切替をサポートする | E-01 行166-170 `{% if separator_html is not defined or separator_html is same as(false) %}` | ○ |
| C-18 | Foundation 5は現在レガシーフレームワークである | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18: Foundation 5のレガシー状態について、Symfony公式ドキュメントまたはFoundation公式サイトでの確認が取れていない
  - 候補：Foundation公式サイト / Symfony公式ドキュメント / CHANGELOG

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 設計書の大部分がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] Foundation 5のレガシー状態に関する記述が適切か確認
- [ ] 全オーバーライドブロックが網羅されているか確認（テンプレート内のblockタグと対照）
- [ ] Twigブロック継承関係の記述が正確か確認
